#include "Controller.h"
#include "Logger.h"
#include "ControllerEvent.h"
#include "ros/ros.h"
#include <sstream>
#include "std_msgs/String.h"
//#include <geometry_msgs/Twist.h>
#include <turtlesim/Velocity.h>


class SendController : public Controller{
public:
  void onInit(InitEvent &evt);
  double onAction(ActionEvent &evt);
  void poseCallback(const turtlesim::VelocityConstPtr& vel);

public:
  int i, j;

  RobotObj *my;
  double rRate;
  double rWlVel;
  double rWlVelTmp;
  double lWlVel;
  double lWlVelTmp;
  bool rState;

  ros::Subscriber pose_sub ;
};


void SendController::poseCallback(const turtlesim::VelocityConstPtr& vel){
  rWlVelTmp = vel->angular/2.0+vel->linear;
  //rWlVelTmp = vel->angular.z/2.0+vel->linear.x;
  lWlVelTmp = vel->linear-vel->angular/2.0;
  //lWlVelTmp = vel->linear.x-vel->angular.z/2.0;
  rState = true;
}


void SendController::onInit(InitEvent &evt){
  rRate = 0.1;

  rWlVel = 0.0;
  rWlVelTmp = 0.0;
  lWlVel = 0.0;
  lWlVelTmp = 0.0;
  rState = false;

  int argc =0;
  char** argv = NULL;
  my = this->getRobotObj(this->myname());
  my->setWheel(10.0, 10.0);
  ros::init(argc, argv, "ros_sig_node");
  ros::NodeHandle n;

  pose_sub = n.subscribe<turtlesim::Velocity>("turtle1/command_velocity", 1,&SendController::poseCallback,this);
  ros::Rate loop_rate(10);
}


double SendController::onAction(ActionEvent &evt){
  if(rState){
    rWlVel = rWlVel+rWlVelTmp;
    lWlVel = lWlVel+lWlVelTmp;
    my->setWheelVelocity(rWlVel, lWlVel);
    rState = false;
  }
  ros::spinOnce();
  return rRate;
}


extern "C"  Controller * createController(){
  return new SendController;
}

